/* Copyright (c) 2018 Boulder Real Time Technologies, Inc. */
/* All rights reserved */

/* This software module is wholly owned by Boulder Real Time 
	Technologies, Inc. Any use of this software module without
	express written permission from Boulder Real Time Technologies,
	Inc. is prohibited. */

#ifndef __BUPF__
#define __BUPF__

#include <stddef.h>
#include <cstdarg>
#include <functional>
#include <string>
#include <vector>
#include <unordered_map>
#include <algorithm>
#include <memory>
#include <iostream>
#include <sstream>
#include <fstream>

#include "Array.h"
#include "stock.h"


#define PF_TYPE_PFFILE		0
#define PF_TYPE_PFSTRING	1

#define PF_INDEX_SOURCE     0
#define PF_INDEX_LEVEL      1
#define PF_INDEX_KEY        2
#define PF_INDEX_VALUE      3
#define PF_INDEX_COMMENT    4
#define PF_INDEX_CONSTRAINTS 5

#define PF_TYPE_STRING  0
#define PF_TYPE_INT     1
#define PF_TYPE_FLOAT   2
#define PF_TYPE_COLOR   3
#define PF_TYPE_FONT    4
#define PF_TYPE_REGEX   5
#define PF_TYPE_LITERAL 6

struct BUPf_Constraint {
    int type;
    Table<std::string> string_enum;
};

class BUPf {
public:
    BUPf(std::string string, int type=PF_TYPE_PFFILE);
    void display();
    void display(int index);
    void display(std::string key);
    int size();
    Table<Table<std::string>> getList();
    Table<std::string> getEntry(std::string key);
    Table<std::string> getEntry(int index);
    std::string getSource(std::string key);
    std::string getSource(int index);
    int getLevel(std::string key);
    int getLevel(int index);
    std::string getKey(int index);
    std::string getValue(std::string key, bool *checkOk = NULL, Table<int> *types=NULL);
    std::string getValue(int index, bool *checkOk = NULL, Table<int> *types=NULL, std::string *value_type=NULL);
    bool checkValue (std::string key, std::string *invalue=NULL, Table<int> *types=NULL);
    bool checkValue (int index, std::string *invalue=NULL, Table<int> *types=NULL);
    std::string getComment(std::string key);
    std::string getComment(int index);
    std::string getConstraints(std::string key, bool *checkOk = NULL);
    std::string getConstraints(int index, bool *checkOk = NULL);
    int getEntryIndex(std::string key);
    std::string getPfString();
    void getPf(Pf **pf);
    void setValue(std::string key, std::string value, int callback_flag=1);
    void setValue(int index, std::string value, int callback_flag=1);
    void setComment(std::string key, std::string comment);
    void setComment(int index, std::string comment);
    void write (std::string &pffile);

    static std::string key2Perl (std::string key);
	static std::string key2Pfkey (std::string key);
	static Table<std::string> key2Table (std::string key);
    static std::string escapeValue (std::string value);
    static std::string unescapeValue (std::string value);

protected:
	virtual void valueChangedCallback (std::string key, int index, std::string from, std::string &to) {};

private:
	Table<Table<std::string>> readPf (std::string &string);
	Table<Table<std::string>> processArr (int level, std::string key_prefix, std::string fname, int &iline, Table<std::string> &pflines, int process_nokeys=0);
	Table<Table<std::string>> processTbl (int level, std::string key_prefix, std::string fname, int &iline, Table<std::string> &pflines, int process_nokeys=0);
    Table<Table<std::string>> processLiteral (int level, std::string originator, std::string terminator, std::string key_prefix, std::string fname, int &iline, Table<std::string> &pflines, int process_nokeys=0);
	Table<Table<std::string>> mergePf (Table<Table<std::string>> &pflistin, Table<Table<std::string>> &pfl);
    int getEntryIndex(std::string key, Table<Table<std::string>> pfl);
    int parseConstraints (std::string constraints_string);
    Table<BUPf_Constraint> getConstraintsTable (int index);

	static Table<std::string> processLine (std::string Line, int tbl=0);
    static bool checkField (std::string field, BUPf_Constraint constraint);
	static void trim (std::string &string);
	static void replace (std::string &string, std::string from, std::string to);
    static Table<std::string> fields (std::string string);
    static int parseLiteralDelimiters (std::string value, std::string &originator, std::string &terminator);

	std::string pffile;
	std::string pfstring;
	Table<Table<std::string>> pflist;
    Array<std::string,Table<BUPf_Constraint>> constraints_array;
};

#endif