/* Copyright (c) 2009 Boulder Real Time Technologies, Inc. */
/* All rights reserved */

#ifndef __busac__
#define __busac__

/* This software module is wholly owned by Boulder Real Time 
   Technologies, Inc. Any use of this software module without
   express written permission from Boulder Real Time Technologies,
   Inc. is prohibited. */

#ifdef  __cplusplus
extern "C" {
#endif

#define	SAC_TYPE_F	1
#define	SAC_TYPE_N	2
#define	SAC_TYPE_I	3
#define	SAC_TYPE_L	4
#define	SAC_TYPE_K	5
#define	SAC_TYPE_K2	6

typedef struct sac_value_format_ {
	long type;
	long size;
	char *null_value_string;
	unsigned char null_value[32];
} sac_value_format;

static sac_value_format SacValueFormats[] = {
	{SAC_TYPE_F,	4,	"-12345.0"},
	{SAC_TYPE_N,	4,	"-12345"},
	{SAC_TYPE_I,	4,	"-12345"},
	{SAC_TYPE_L,	4,	"0"},
	{SAC_TYPE_K,	8,	"-12345"},
	{SAC_TYPE_K2,	16,	"-12345"},
};

typedef struct sac_header_define_ {
	char *name;
	long type;
	long offset;
	char *description;
	sac_value_format *format;
} sac_header_define;

static sac_header_define SacHeaderDefines[] = {
	{"DELTA",	SAC_TYPE_F,	0,	"sample time increment (sec)"},
	{"DEPMIN",	SAC_TYPE_F,	4,	"minimum value of dependent variable"},
	{"DEPMAX",	SAC_TYPE_F,	8,	"maximum value of dependent variable"},
	{"SCALE",	SAC_TYPE_F,	12,	"multiplying scale factor for dependent variable"},
	{"ODELTA",	SAC_TYPE_F,	16,	"observed sample time increment (sec)"},
	{"B",		SAC_TYPE_F,	20,	"beginning value of independent variable (seconds relative to reference time)"},
	{"E",		SAC_TYPE_F,	24,	"ending value of independent variable (seconds relative to reference time)"},
	{"O",		SAC_TYPE_F,	28,	"event origin time (seconds relative to reference time)"},
	{"A",		SAC_TYPE_F,	32,	"first arrival time (seconds relative to reference time)"},
	{"INTERNAL1",	SAC_TYPE_F,	36,	"sac internal variable"},
	{"T0",		SAC_TYPE_F,	40,	"user defined time pick 0 (seconds relative to reference time)"},
	{"T1",		SAC_TYPE_F,	44,	"user defined time pick 1 (seconds relative to reference time)"},
	{"T2",		SAC_TYPE_F,	48,	"user defined time pick 2 (seconds relative to reference time)"},
	{"T3",		SAC_TYPE_F,	52,	"user defined time pick 3 (seconds relative to reference time)"},
	{"T4",		SAC_TYPE_F,	56,	"user defined time pick 4 (seconds relative to reference time)"},
	{"T5",		SAC_TYPE_F,	60,	"user defined time pick 5 (seconds relative to reference time)"},
	{"T6",		SAC_TYPE_F,	64,	"user defined time pick 6 (seconds relative to reference time)"},
	{"T7",		SAC_TYPE_F,	68,	"user defined time pick 7 (seconds relative to reference time)"},
	{"T8",		SAC_TYPE_F,	72,	"user defined time pick 8 (seconds relative to reference time)?"},
	{"T9",		SAC_TYPE_F,	76,	"user defined time pick 9 (seconds relative to reference time)"},
	{"F",		SAC_TYPE_F,	80,	"end of event time (seconds relative to reference time)"},
	{"RESP0",	SAC_TYPE_F,	84,	"instrument response parameter 0"},
	{"RESP1",	SAC_TYPE_F,	88,	"instrument response parameter 1"},
	{"RESP2",	SAC_TYPE_F,	92,	"instrument response parameter 2"},
	{"RESP3",	SAC_TYPE_F,	96,	"instrument response parameter 3"},
	{"RESP4",	SAC_TYPE_F,	100,	"instrument response parameter 4"},
	{"RESP5",	SAC_TYPE_F,	104,	"instrument response parameter 5"},
	{"RESP6",	SAC_TYPE_F,	108,	"instrument response parameter 6"},
	{"RESP7",	SAC_TYPE_F,	112,	"instrument response parameter 7"},
	{"RESP8",	SAC_TYPE_F,	116,	"instrument response parameter 8"},
	{"RESP9",	SAC_TYPE_F,	120,	"instrument response parameter 9"},
	{"STLA",	SAC_TYPE_F,	124,	"station latitude (deg, north positive)"},
	{"STLO",	SAC_TYPE_F,	128,	"station longitude (deg, east positive)"},
	{"STEL",	SAC_TYPE_F,	132,	"station elevation (meters)"},
	{"STDP",	SAC_TYPE_F,	136,	"station depth below surface (meters)"},
	{"EVLA",	SAC_TYPE_F,	140,	"event latitude (deg, north positive)"},
	{"EVLO",	SAC_TYPE_F,	144,	"event longitude (deg, east positive)"},
	{"EVEL",	SAC_TYPE_F,	148,	"event elevation (meters)"},
	{"EVDP",	SAC_TYPE_F,	152,	"event depth below surface (meters)"},
	{"MAG",		SAC_TYPE_F,	156,	"event magnitude"},
	{"USER0",	SAC_TYPE_F,	160,	"user defined variable 0"},
	{"USER1",	SAC_TYPE_F,	164,	"user defined variable 1"},
	{"USER2",	SAC_TYPE_F,	168,	"user defined variable 2"},
	{"USER3",	SAC_TYPE_F,	172,	"user defined variable 3"},
	{"USER4",	SAC_TYPE_F,	176,	"user defined variable 4"},
	{"USER5",	SAC_TYPE_F,	180,	"user defined variable 5"},
	{"USER6",	SAC_TYPE_F,	184,	"user defined variable 6"},
	{"USER7",	SAC_TYPE_F,	188,	"user defined variable 7"},
	{"USER8",	SAC_TYPE_F,	192,	"user defined variable 8"},
	{"USER9",	SAC_TYPE_F,	196,	"user defined variable 9"},
	{"DIST",	SAC_TYPE_F,	200,	"station to event distance (km)"},
	{"AZ",		SAC_TYPE_F,	204,	"event to station azimuth (deg)"},
	{"BAZ",		SAC_TYPE_F,	208,	"station to event azimuth (deg)"},
	{"GCARC",	SAC_TYPE_F,	212,	"station to event great circle arc length (deg)"},
	{"INTERNAL2",	SAC_TYPE_F,	216,	"sac internal variable"},
	{"INTERNAL3",	SAC_TYPE_F,	220,	"sac internal variable"},
	{"DEPMEN",	SAC_TYPE_F,	224,	"mean value of dependent variable"},
	{"CMPAZ",	SAC_TYPE_F,	228,	"component azimuth from north (deg)"},
	{"CMPINC",	SAC_TYPE_F,	232,	"component incident angle from vertical (deg)"},
	{"XMINIMUM",	SAC_TYPE_F,	236,	"minimum value of X"},
	{"XMAXIMUM",	SAC_TYPE_F,	240,	"maximum value of X"},
	{"YMINIMUM",	SAC_TYPE_F,	244,	"minimum value of Y"},
	{"YMAXIMUM",	SAC_TYPE_F,	248,	"maximum value of Y"},
	{"UNUSED1",	SAC_TYPE_F,	252,	"?"},
	{"UNUSED2",	SAC_TYPE_F,	256,	"?"},
	{"UNUSED3",	SAC_TYPE_F,	260,	"?"},
	{"UNUSED4",	SAC_TYPE_F,	264,	"?"},
	{"UNUSED5",	SAC_TYPE_F,	268,	"?"},
	{"UNUSED6",	SAC_TYPE_F,	272,	"?"},
	{"UNUSED7",	SAC_TYPE_F,	276,	"?"},
	{"NZYEAR",	SAC_TYPE_N,	280,	"GMT year corresponding to reference time`"},
	{"NZJDAY",	SAC_TYPE_N,	284,	"GMT Julian day corresponding to reference time`"},
	{"NZHOUR",	SAC_TYPE_N,	288,	"GMT hour corresponding to reference time`"},
	{"NZMIN",	SAC_TYPE_N,	292,	"GMT minute corresponding to reference time`"},
	{"NZSEC",	SAC_TYPE_N,	296,	"GMT integer second corresponding to reference time`"},
	{"NZMSEC",	SAC_TYPE_N,	300,	"GMT integer millisecond corresponding to reference time`"},
	{"NVHDR",	SAC_TYPE_N,	304,	"header version number"},
	{"NORID",	SAC_TYPE_N,	308,	"CSS 3.0 schema corresponding origin orid value"},
	{"NEVID",	SAC_TYPE_N,	312,	"CSS 3.0 schema corresponding event evid value"},
	{"NPTS",	SAC_TYPE_N,	316,	"number of points per data component"},
	{"INTERNAL4",	SAC_TYPE_N,	320,	"sac internal variable"},
	{"NWFID",	SAC_TYPE_N,	324,	"CSS 3.0 schema corresponding wfdisc wfid value"},
	{"NXSIZE",	SAC_TYPE_N,	328,	"spectral length"},
	{"NYSIZE",	SAC_TYPE_N,	332,	"spectral width"},
	{"UNUSED8",	SAC_TYPE_N,	336,	"?"},
	{"IFTYPE",	SAC_TYPE_I,	340,	"type of file"},
	{"IDEP",	SAC_TYPE_I,	344,	"type of dependent variable"},
	{"IZTYPE",	SAC_TYPE_I,	348,	"reference time equivalence"},
	{"UNUSED9",	SAC_TYPE_N,	352,	"?"},
	{"IINST",	SAC_TYPE_I,	356,	"type of recording instrument"},
	{"ISTREG",	SAC_TYPE_I,	360,	"station geographic region"},
	{"IEVREG",	SAC_TYPE_I,	364,	"event geographic region"},
	{"IEVTYP",	SAC_TYPE_I,	368,	"type of event"},
	{"IQUAL",	SAC_TYPE_I,	372,	"quality of data"},
	{"ISYNTH",	SAC_TYPE_I,	376,	"synthetic data flag"},
	{"IMAGTYP",	SAC_TYPE_I,	380,	"magnitude type"},
	{"IMAGSRC",	SAC_TYPE_I,	384,	"source of magnitude information"},
	{"UNUSED10",	SAC_TYPE_N,	388,	"?"},
	{"UNUSED11",	SAC_TYPE_N,	392,	"?"},
	{"UNUSED12",	SAC_TYPE_N,	396,	"?"},
	{"UNUSED13",	SAC_TYPE_N,	400,	"?"},
	{"UNUSED14",	SAC_TYPE_N,	404,	"?"},
	{"UNUSED15",	SAC_TYPE_N,	408,	"?"},
	{"UNUSED16",	SAC_TYPE_N,	412,	"?"},
	{"UNUSED17",	SAC_TYPE_N,	416,	"?"},
	{"LEVEN",	SAC_TYPE_L,	420,	"TRUE if data is evenly spaced"},
	{"LPSPOL",	SAC_TYPE_L,	424,	"TRUE if station components have a positive polarity (left-hand rule)"},
	{"LOVROK",	SAC_TYPE_L,	428,	"TRUE if it is ok to overwrite this file on disk"},
	{"LCALDA",	SAC_TYPE_L,	432,	"TRUE if DIST, AZ, BAZ, GCARC are to be calculated from station and event coordinates"},
	{"UNUSED18",	SAC_TYPE_L,	436,	"?"},
	{"KSTNM",	SAC_TYPE_K,	440,	"station name"},
	{"KEVNM",	SAC_TYPE_K2,	448,	"event name"},
	{"KHOLE",	SAC_TYPE_K,	464,	"hole identification if man-made source"},
	{"KO",		SAC_TYPE_K,	472,	"event origin time identification"},
	{"KA",		SAC_TYPE_K,	480,	"first arrival time identification"},
	{"KT0",		SAC_TYPE_K,	488,	"user defined time pick 0 identification"},
	{"KT1",		SAC_TYPE_K,	496,	"user defined time pick 1 identification"},
	{"KT2",		SAC_TYPE_K,	504,	"user defined time pick 2 identification"},
	{"KT3",		SAC_TYPE_K,	512,	"user defined time pick 3 identification"},
	{"KT4",		SAC_TYPE_K,	520,	"user defined time pick 4 identification"},
	{"KT5",		SAC_TYPE_K,	528,	"user defined time pick 5 identification"},
	{"KT6",		SAC_TYPE_K,	536,	"user defined time pick 6 identification"},
	{"KT7",		SAC_TYPE_K,	544,	"user defined time pick 7 identification"},
	{"KT8",		SAC_TYPE_K,	552,	"user defined time pick 8 identification"},
	{"KT9",		SAC_TYPE_K,	560,	"user defined time pick 9 identification"},
	{"KF",		SAC_TYPE_K,	568,	"end of event time identification"},
	{"KUSER0",	SAC_TYPE_K,	576,	"user defined variable 0 identification"},
	{"KUSER1",	SAC_TYPE_K,	584,	"user defined variable 1 identification"},
	{"KUSER2",	SAC_TYPE_K,	592,	"user defined variable 2 identification"},
	{"KCMPNM",	SAC_TYPE_K,	600,	"component name"},
	{"KNETWK",	SAC_TYPE_K,	608,	"network name"},
	{"KDATRD",	SAC_TYPE_K,	616,	"date data was read unto computer"},
	{"KINST",	SAC_TYPE_K,	624,	"generic name of recording instrument"},
};

#define BUSAC_CURRENT_NVHDR	((int)6)
#define SAC_HEADER_SIZE		632

typedef struct sac_image_ {
	unsigned char header[SAC_HEADER_SIZE];
	float *data;
	long data_nsamples;
	unsigned long data_size;
} SacImage;

#define	SAC_ENUM_ITIME		(long)1
#define	SAC_ENUM_IUNKN		(long)5
#define	SAC_ENUM_IDISP		(long)6
#define	SAC_ENUM_IVEL		(long)7
#define	SAC_ENUM_IACC		(long)8
#define	SAC_ENUM_IB		(long)9
#define	SAC_ENUM_IDAY		(long)10
#define	SAC_ENUM_IO		(long)11
#define	SAC_ENUM_IA		(long)12

#define	SAC_BOOLEAN_TRUE	(long)1
#define	SAC_BOOLEAN_FALSE	(long)0

extern sac_header_define *busac_get_header_define (char *name);

#ifdef  __cplusplus
}
#endif

#endif
