/* Copyright (c) 2005 Boulder Real Time Technologies, Inc. */
/* All rights reserved */

/* This software module is wholly owned by Boulder Real Time 
   Technologies, Inc. Any use of this software module without
   express written permission from Boulder Real Time Technologies,
   Inc. is prohibited. */

#ifndef __sourcecounter__
#define __sourcecounter__

#include <pthread.h>
#include <string.h>
#include "stock.h"
#include "brttutil.h"

typedef struct sourcecounter_ {
	pthread_mutex_t	mutex;
	Arr* 		sources;
	double		twin;
	double 		time;
} SourceCounter;

#ifdef  __cplusplus
extern "C" {
#endif

SourceCounter *sourcecounter_create( double twin );
int sourcecounter_destroy( SourceCounter *sc );
int sourcecounter_put( SourceCounter *sc, char *srcname, double time );
int sourcecounter_get( SourceCounter *sc, long *nsources );
int sourcecounter_fprintf( int fd, char *fmt, ... );
int sourcecounter_write_state( SourceCounter *sc, char *name, int fd );
int sourcecounter_read_state( SourceCounter *sc, char *name, Pf *pf );
Pf* sourcecounter_create_state_pf( SourceCounter *sc );

#ifdef  __cplusplus
}
#endif

#endif
