/* Copyright (c) 2005 Boulder Real Time Technologies, Inc. */
/* All rights reserved */

/* This software module is wholly owned by Boulder Real Time 
   Technologies, Inc. Any use of this software module without
   express written permission from Boulder Real Time Technologies,
   Inc. is prohibited. */

#ifndef __taverage__
#define __taverage__

#include <pthread.h>
#include "brttutil.h"

typedef struct taverage_ {
	pthread_mutex_t mutex;
	double tbin;
	double twin;
	int nbin;
	double *bins;
	double time;
} TAverage;

#ifdef  __cplusplus
extern "C" {
#endif

TAverage *taverage_create (double time, double tbin, int nbin);
int taverage_destroy (TAverage *ta);
int taverage_put (TAverage *ta, double value);
int taverage_get (TAverage *ta, double *time, double *twin, double *sum, double *ave);
int taverage_fprintf( int fd, char *fmt, ... );
int taverage_write_state (TAverage *ta, char *name, int fd);
int taverage_read_state (TAverage *ta, char *name, Pf *pf);
Pf* taverage_create_state_pf (TAverage *ta);

#ifdef  __cplusplus
}
#endif

#endif
