/* Copyright (c) 2020 Boulder Real Time Technologies, Inc. */
/* All rights reserved */

/* This software module is wholly owned by Boulder Real Time
   Technologies, Inc. Any use of this software module without
   express written permission from Boulder Real Time Technologies,
   Inc. is prohibited. */

#ifndef __buassoc__
#define __buassoc__

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include <math.h>

#include "orb.h"
#include "xtra.h"
#include "tr.h"
#include "db.h"
#include "stock.h"
#include "brttutil.h"
#include "tt.h"
#include "BUConfigure.h"
#include "EV.h"

struct assoc_params_ {
	assoc_params_ () {
		memset (this, 0, sizeof(assoc_params_));
	}

	char *assoc_method;
	char *assoc_model;
	char *assoc_phases;
	char *assoc_screen_new;
	char *assoc_screen_old;
	char *assoc_expression;
	double assoc_P_thresh;
	double assoc_S_thresh;
	int assoc_ignoreiphase;
	int assoc_firstphase;
	Arr *author_priority_arr;
};

struct arrival_ {
	arrival_ () {
		memset (this, 0, sizeof(arrival_));
	}

	char	rec_arrival[512];
	char	rec_assoc[512];
	char	rec_predarr[512];
	char	sta[16];
	char	chan[16];
	char	iphase[16];
	char	phase[16];
	double  time;
	double  timeres;
	double  predtime;
	double  lat;
	double  lon;
	double  elev;
	double  delta;
	double  esaz;
	double  seaz;
	int	coords;
	long	arid;
	long	arid_save;
	long	arrival_record;
	long	orid;
	int	defining;
};

class BUAssoc;

typedef int (BU_preforCallback) (BUAssoc *assoc, EVEvent event, BU_ClientData client_data);

struct BuAssocPreforCallback {
        BuAssocPreforCallback () {
                memset (this, 0, sizeof(BuAssocPreforCallback));
        }

        std::function<BU_preforCallback> callback_proc;
        BU_ClientData client_data;
};

class BUAssoc {
public:
	BUAssoc (Dbptr db, Pf *pf=NULL, int map_wait=0, double wait_timeout=3600.0);
	~BUAssoc ();

	int makeOrigin (Pf *pf, std::string &schema, EVOrigin &origin, 
				bool &magnitude_update, std::string &review, bool &mt_update, 
				bool &use_orid_for_match, bool &archive_if_not_associated, int verbose);
	int process (Pf *pfin, int verbose=0);
	int processOrigin (std::string schema, EVOrigin origin,
								bool magnitude_update=false, std::string review="", bool mt_update=false, 
								bool use_orid_for_match=false, 
								bool archive_if_not_associated=true, int verbose=0);
	void setPreforCallback (std::function<BU_preforCallback> preforCallback, BU_ClientData client_data=NULL);

private:
	int processMagnitude (std::string schema, long recno_existing_origin, EVOrigin origin, 
								std::string review="", int verbose=0);
	int processMoment (std::string schema, long recno_existing_origin, EVOrigin origin, int verbose);
	int assoc_event (long nars, struct arrival_ * ars, long orid, 
								double etime, double elat, double elon, double edepth);
	int assoc_event (Table<arrival_> &ars, long orid, 
								double etime, double elat, double elon, double edepth);
	int magnitude_update (long recno, Pf *pfin, Dbptr db, int verbose);
	int mt_update (long recno, Pf *pfin, Dbptr db, int verbose);
	int parsePf (Pf *pf);
	int setDbTables();
	void freeHooks();
	void freeTables();
	void freeDbs();
	int wait();
	int mapSchema (std::string schema, int verbose);
	int matchOrigin (Dbptr dborigin_new, bool use_orid_for_match, long &recno);
	int matchArrival (Dbptr dbarrival_new, long &recno);
	int findEVIdMatch (EVStamag stamag, EVOrigin origin, EVAssociation &association);
	int getDbptr (EVEvent *event, Dbptr *dbptr_event);
	int getDbptr (EVOrigin *origin, Dbptr *dbptr_origin, Dbptr *dbptr_origerr=NULL, Dbptr *dbptr_emodel=NULL);
	int getDbptr (EVAssociation *association, Dbptr *dbptr_assoc, Dbptr *dbptr_arrival=NULL, Dbptr *dbptr_site=NULL, Dbptr *dbptr_predarr=NULL);
	int getDbptr (EVMagnitude *magnitude, Dbptr *dbptr_netmag);
	int getDbptr (EVMoment *moment, Dbptr *dbptr_mt);
	int getDbptr (EVWfmeas *wfmeas, Dbptr *dbptr_wfmeas);
	int getDbptr (EVStamag *stamag, Dbptr *dbptr_stamag);
	int makeArrivals (Dbptr dbor, Table<arrival_> &arrivals, double &residual, char *msg, int verbose);
	int makeArrivals (EVOrigin origin, Dbptr dbar_existing, Table<arrival_> &arrivals, 
								double &residual, long &ndef, long &n_defining_and_coords, char *msg, int verbose);
	int convertScratch (Dbptr db_new, Dbptr &db);
	Dbptr returnScratch (Dbptr db_new, Dbptr db_old);
	int getSite (Dbptr dbarrival, EVAssociation &association);
	int getPredarr (Pf *pf, long orid, EVAssociation &association);
	int getStamags (Pf *pf, EVMagnitude &magnitude);
	int getWfmeass (Pf *pf, EVStamag &stamag);

	BuAssocPreforCallback preforCallback;

	int map_wait;
	Dbptr db;
	char *dbname=NULL;
	char *schema=NULL;
    char *waitfile=NULL;
    double wait_timeout;
    int *lock=NULL;
    int lost_waitfile = 0;
    int last_count = 0;
    Array<std::string, Dbptr> dbptr_new_arr;
    Dbptr db_new;

	assoc_params_ assoc_params;

	Hook *tt_hook=NULL;
	Hook *hookor=NULL;
	Hook *hookor2=NULL;
	Hook *hookev=NULL;
	Hook *hookst=NULL;
	Hook *hookas=NULL;
	Hook *hookar=NULL;
	Hook *hookar2=NULL;
	Hook *hookar3=NULL;
	Hook *hookpd=NULL;
	Hook *hookwm=NULL;
	Hook *hooknm=NULL;
	Hook *hookmt=NULL;

	Dbptr dborigin=dbinvalid();
	Dbptr dborigerr=dbinvalid();
	Dbptr dbevent=dbinvalid();
	Dbptr dbassoc=dbinvalid();
	Dbptr dbarrival=dbinvalid();
	Dbptr dbsite=dbinvalid();
	Dbptr dbnetmag=dbinvalid();
	Dbptr dbstamag=dbinvalid();
	Dbptr dbmt=dbinvalid();
	Dbptr dbwfmeas=dbinvalid();
	Dbptr dbemodel=dbinvalid();
	Dbptr dbpredarr=dbinvalid();

	Tbl *origin_orid_match_tbl=NULL;
	Tbl *origin_default_exact_match_tbl=NULL;
	Tbl *origin_screening_new_tbl=NULL;
	Tbl *origin_screening_old_tbl=NULL;
	Tbl *arrival_match_tbl=NULL;
	Tbl *wfmeas_match_tbl=NULL;
	Tbl *mt_match_tbl=NULL;

	Hook *hook_origin_orid_match=NULL;
	Hook *hook_origin_exact_match=NULL;
	Hook *hook_origin_screening=NULL;
	Hook *hook_origin_event=NULL;
	Hook *hook_origin_assoc=NULL;
	Hook *hook_assoc_arrival=NULL;
	Hook *hook_arrival_site=NULL;
	Hook *hook_arrival_match=NULL;
	Hook *hook_origin_netmag=NULL;
	Hook *hook_wfmeas_match=NULL;
	Hook *hook_mt_match=NULL;
};

#endif