/* Copyright (c) 2015 Boulder Real Time Technologies, Inc. */
/* All rights reserved */

/* This software module is wholly owned by Boulder Real Time 
   Technologies, Inc. Any use of this software module without
   express written permission from Boulder Real Time Technologies,
   Inc. is prohibited. */

#ifndef __buconfigure__
#define __buconfigure__

#include <stddef.h>
#include <cstdarg>

#include "brttutil.h"
#include "Array.h"

struct BU_Name {
	BU_Name () {
		obj = NULL;
	}

	std::string name;
	std::string class_name;
	void *obj;
};

static Array<std::string, BU_Name *> BU_NamesArr;
static Array<std::string, BU_Name *> BU_ObjectsArr;

#define BU_CONFIGURE_OK				0
#define BU_CONFIGURE_DEFAULT			1
#define BU_CONFIGURE_UNDEFINED_PARAMETERS	2
#define BU_CONFIGURE_UNRECOGNIZED_TYPE		3
#define BU_CONFIGURE_ERROR			-1

#define BU_CONFIGURE_NULL_OK               (1 << 0)
#define BU_CONFIGURE_DONT_SET_DEFAULT      (1 << 3)
#define BU_CONFIGURE_OPTION_SET	           (1 << 4)
#define BU_CONFIGURE_ERROR_ON_UNDEFINED    (1 << 5)
#define BU_CONFIGURE_USER_BIT              0x100

typedef void *BU_ClientData;

typedef struct BU_ConfigureSpec {
	const char *type;
	const char *name;
	const char *defValue;
	int offset;
	int specFlags;
	struct BU_CustomOption *customPtr;
} BU_ConfigureSpec;

typedef int (BU_OptionParseProc) (BU_ConfigureSpec *spec, BU_ClientData clientData,
		char *value, char *paramRec, int offset, void *object_ptr);
typedef char *(BU_OptionPrintProc) (BU_ConfigureSpec *spec, BU_ClientData clientData,
		char *paramRec, int offset, void *object_ptr);
typedef int (BU_TypeParserProc) (BU_ConfigureSpec *spec, char *value, char *paramRec, void *object_ptr);

typedef struct BU_CustomOption {
	BU_OptionParseProc *parseProc;
	BU_OptionPrintProc *printProc;
	BU_ClientData clientData;
} BU_CustomOption;

#ifdef offsetof
#define BU_Offset(type, field) ((int) offsetof(type, field))
#else
#define BU_Offset(type, field) ((int) ((char *) &((type *) 0)->field))
#endif

#ifdef  __cplusplus

struct BUConfigureSpecs {
	BUConfigureSpecs () {
		memset (this, 0, sizeof(BUConfigureSpecs));	
	}
	~BUConfigureSpecs () {
		if (class_name) free (class_name);
	}

	BU_ConfigureSpec *configureSpec;
	char *paramRec;
	BU_TypeParserProc *typeParser;
	char *class_name;
	void *object_ptr;
};

class BUConfigure {
public:
	BUConfigure ();
	~BUConfigure ();
	int addTypeParser (std::string type_name, BU_TypeParserProc proc);
	int setConfigureSpecs (BU_ConfigureSpec *configSpecs, char *paramRec, const char *class_name, void *object_ptr = NULL, int set_defaults = 1);
	int configure (Pf *params);
	int configure (char *key1, ...);
	int configure (const char *key1, ...);
	int vconfigure (char *key1, va_list args);
private:
	int configurePf (BU_ConfigureSpec *specs, Pf *params, char *paramRec, int flags);
	int configurePf (Pf *params, int flags);
	int configureVarargs (char *key1, va_list args);
	Table<BUConfigureSpecs *> configure_specs_tbl;
	Array<std::string, BUConfigureSpecs *> configure_specs_arr;
	Array<std::string, BU_TypeParserProc *> type_parsers_arr;
};

extern void bu_ptimes (char *string, int reset=0);
extern void bu_ptimes (const char *string, int reset=0);

#endif

extern "C" {
extern int BU_ParseBooleanAsBoolean (char *value, bool &boolean);
extern int BU_ParseBoolean (char *value, int *boolean);
extern int BU_Strcmp (char *str1, char *str2);
extern int BU_SetName (char *name, char *class_name, void *obj);
extern void *BU_GetObject (char *name, char *class_name);
extern char *BU_GetName (void *object, char *class_name);
extern void bu_register_error (int flag, const char *format, ...)__attribute__ ((format (printf, 2, 3)));
extern void bu_elog_notify (int flag, const char *format, ...)__attribute__ ((format (printf, 2, 3)));
extern void bu_complain (int flag, const char *format, ...)__attribute__ ((format (printf, 2, 3)));
extern void bu_die (int flag, const char *format, ...)__attribute__ ((format (printf, 2, 3)));
extern void bu_clear_register (int flag);
extern char *bu_elog_string (int first);
}

#endif
